/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.SubGuiEditText;
import noppes.npcs.client.gui.SubGuiMailmanSendSetup;
import noppes.npcs.client.gui.SubGuiNpcCommand;
import noppes.npcs.client.gui.SubGuiNpcFactionOptions;
import noppes.npcs.client.gui.SubGuiNpcQuestExtra;
import noppes.npcs.client.gui.SubGuiNpcTextArea;
import noppes.npcs.client.gui.global.SubGuiQuestObjectiveSelect;
import noppes.npcs.client.gui.questtypes.GuiNpcQuestTypeDialog;
import noppes.npcs.client.gui.questtypes.GuiNpcQuestTypeKill;
import noppes.npcs.client.gui.questtypes.GuiNpcQuestTypeLocation;
import noppes.npcs.client.gui.questtypes.GuiNpcQuestTypeManual;
import noppes.npcs.client.gui.select.GuiQuestSelection;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.GuiSelectionListener;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumQuestRepeat;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.quests.QuestObjective;

public class GuiQuestEdit
extends SubGuiInterface
implements ICustomScrollListener,
ISubGuiListener,
GuiSelectionListener,
ITextfieldListener,
IGuiData,
GuiYesNoCallback {
    private Quest quest;
    private GuiCustomScroll scrollTasks;
    private String task = "";
    private Map<String, QuestObjective> tasksData;

    public GuiQuestEdit(Quest q) {
        this.setBackground("menubg.png");
        this.xSize = 386;
        this.ySize = 226;
        this.closeOnEsc = true;
        this.quest = q;
        NoppesUtilServer.setEditingQuest((EntityPlayer)this.player, q);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 3: {
                this.setSubGui(new SubGuiNpcTextArea(0, this.quest.completeText));
                break;
            }
            case 4: {
                this.setSubGui(new SubGuiNpcTextArea(1, this.quest.logText));
                break;
            }
            case 5: {
                Client.sendData(EnumPacketServer.QuestOpenGui, new Object[]{EnumGuiType.QuestReward, this.quest.save(new NBTTagCompound())});
                break;
            }
            case 8: {
                this.quest.repeat = EnumQuestRepeat.values()[button.getValue()];
                break;
            }
            case 9: {
                this.setSubGui(new SubGuiNpcQuestExtra(0, this.quest));
                break;
            }
            case 10: {
                this.setSubGui(new SubGuiNpcFactionOptions(this.quest.factionOptions));
                break;
            }
            case 11: {
                this.setSubGui(new GuiQuestSelection(this.quest.nextQuest));
                break;
            }
            case 12: {
                this.quest.nextQuest = -1;
                this.func_73866_w_();
                break;
            }
            case 13: {
                this.setSubGui(new SubGuiMailmanSendSetup(this.quest.mail));
                break;
            }
            case 14: {
                this.quest.mail = new PlayerMail();
                this.func_73866_w_();
                break;
            }
            case 15: {
                this.setSubGui(new SubGuiNpcCommand(this.quest.command));
                break;
            }
            case 16: {
                this.quest.questInterface.upPos(this.tasksData.get(this.scrollTasks.getSelected()));
                this.save();
                this.func_73866_w_();
                break;
            }
            case 17: {
                this.quest.questInterface.downPos(this.tasksData.get(this.scrollTasks.getSelected()));
                this.save();
                this.func_73866_w_();
                break;
            }
            case 18: {
                this.quest.step = button.getValue();
                break;
            }
            case 19: {
                this.setSubGui(new SubGuiQuestObjectiveSelect(this));
                break;
            }
            case 20: {
                if (!this.quest.questInterface.removeTask(this.tasksData.get(this.task))) break;
                this.task = "";
                this.save();
                this.func_73866_w_();
                break;
            }
            case 21: {
                if (this.task.isEmpty() || !this.tasksData.containsKey(this.task)) {
                    return;
                }
                if (this.tasksData.get(this.task).getEnumType() == EnumQuestTask.DIALOG) {
                    this.setSubGui(new GuiNpcQuestTypeDialog(this.npc, this.tasksData.get(this.task), this));
                    break;
                }
                if (this.tasksData.get(this.task).getEnumType() == EnumQuestTask.KILL) {
                    this.setSubGui(new GuiNpcQuestTypeKill(this.npc, this.tasksData.get(this.task), this));
                    break;
                }
                if (this.tasksData.get(this.task).getEnumType() == EnumQuestTask.LOCATION) {
                    this.setSubGui(new GuiNpcQuestTypeLocation(this.npc, this.tasksData.get(this.task), this));
                    break;
                }
                if (this.tasksData.get(this.task).getEnumType() == EnumQuestTask.AREAKILL) {
                    this.setSubGui(new GuiNpcQuestTypeKill(this.npc, this.tasksData.get(this.task), this));
                    break;
                }
                if (this.tasksData.get(this.task).getEnumType() == EnumQuestTask.MANUAL) {
                    this.setSubGui(new GuiNpcQuestTypeManual(this.npc, this.tasksData.get(this.task), this));
                    break;
                }
                Client.sendData(EnumPacketServer.QuestReset, this.quest.save(new NBTTagCompound()), this.quest.questInterface.getPos(this.tasksData.get(this.task)));
                break;
            }
            case 22: {
                this.quest.setCancelable(button.getValue() == 0);
                this.getLabel(16).setEnabled(this.quest.isCancelable());
                if (!this.quest.isCancelable()) break;
                if (this.quest.forgetDialogues.length == 0) {
                    TreeMap<Integer, Dialog> dialogs = DialogController.instance.dialogs;
                    for (int id : dialogs.keySet()) {
                        if (dialogs.get((Object)Integer.valueOf((int)id)).quest != this.quest.id) continue;
                        this.quest.forgetDialogues = new int[]{id};
                        break;
                    }
                }
                if (this.quest.forgetQuests.length == 0) {
                    TreeMap<Integer, Quest> quests = QuestController.instance.quests;
                    for (int id : quests.keySet()) {
                        if (id == this.quest.id || quests.get((Object)Integer.valueOf((int)id)).nextQuest != this.quest.id) continue;
                        this.quest.forgetQuests = new int[]{id};
                        break;
                    }
                }
                String[] texts = new String[]{"", ""};
                int i = 0;
                for (int id : this.quest.forgetDialogues) {
                    texts[0] = texts[0] + id;
                    if (i < this.quest.forgetDialogues.length - 1) {
                        texts[0] = texts[0] + ",";
                    }
                    ++i;
                }
                i = 0;
                for (int id : this.quest.forgetQuests) {
                    texts[1] = texts[1] + id;
                    if (i < this.quest.forgetQuests.length - 1) {
                        texts[1] = texts[1] + ",";
                    }
                    ++i;
                }
                SubGuiEditText subgui = new SubGuiEditText(1, texts);
                subgui.setHoverTexts(new String[]{"quest.hover.forget.dialogues", "quest.hover.forget.quests"});
                this.setSubGui(subgui);
                break;
            }
            case 23: {
                this.quest.level = button.getValue();
                break;
            }
            case 24: {
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("message.change.id", new Object[]{"" + this.quest.id}).func_150254_d(), new TextComponentTranslation("message.change", new Object[0]).func_150254_d(), 0);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    public void func_73878_a(boolean result, int id) {
        if (this.parent instanceof GuiNPCInterface2) {
            ((GuiNPCInterface)this.parent).setSubGui(this);
            NoppesUtil.openGUI((EntityPlayer)this.player, this.parent);
        } else {
            NoppesUtil.openGUI((EntityPlayer)this.player, this);
        }
        if (!result) {
            return;
        }
        if (id == 0) {
            Client.sendData(EnumPacketServer.QuestMinID, this.quest.id);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.quest = NoppesUtilServer.getEditingQuest((EntityPlayer)this.player);
        this.quest.questInterface.fix();
        this.tasksData = this.quest.questInterface.getKeys();
        NoppesUtilServer.setEditingQuest((EntityPlayer)this.player, this.quest);
        this.addLabel(new GuiNpcLabel(1, "gui.title", this.guiLeft + 4, this.guiTop + 10));
        GuiNpcTextField textField = new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + 45, this.guiTop + 5, 127, 20, this.quest.getName());
        textField.setHoverText("quest.hover.edit.quest.name", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(0, "ID: " + this.quest.id, this.guiLeft + 175, this.guiTop + 5));
        this.addLabel(new GuiNpcLabel(2, "type.level", this.guiLeft + 175, this.guiTop + 15));
        this.addLabel(new GuiNpcLabel(3, "quest.completedtext", this.guiLeft + 4, this.guiTop + 35));
        GuiNpcButton button = new GuiNpcButton(3, this.guiLeft + 120, this.guiTop + 30, 50, 20, this.quest.completeText.isEmpty() ? "selectServer.edit" : "advanced.editingmode");
        button.setHoverText("quest.hover.edit.quest.completedtext", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(4, "quest.questlogtext", this.guiLeft + 4, this.guiTop + 57));
        button = new GuiNpcButton(4, this.guiLeft + 120, this.guiTop + 52, 50, 20, this.quest.logText.isEmpty() ? "selectServer.edit" : "advanced.editingmode");
        button.setHoverText("quest.hover.edit.quest.questlogtext", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(5, "quest.reward", this.guiLeft + 4, this.guiTop + 79));
        button = new GuiNpcButton(5, this.guiLeft + 120, this.guiTop + 74, 50, 20, this.quest.rewardItems.func_191420_l() && this.quest.rewardExp <= 0 ? "selectServer.edit" : "advanced.editingmode");
        button.setHoverText("quest.hover.edit.quest.reward", new Object[0]);
        this.addButton(button);
        this.addLabel(this.getTasksLabel());
        if (this.scrollTasks == null) {
            this.scrollTasks = new GuiCustomScroll(this, 6);
            this.scrollTasks.setSize(209, 94);
        }
        this.scrollTasks.setList(new ArrayList<String>(this.tasksData.keySet()));
        this.scrollTasks.guiLeft = this.guiLeft + 172;
        this.scrollTasks.guiTop = this.guiTop + 96;
        int pos = -1;
        if (!this.task.isEmpty()) {
            this.scrollTasks.setSelected(this.task);
            pos = this.quest.questInterface.getPos(this.tasksData.get(this.task));
        }
        this.addScroll(this.scrollTasks);
        button = new GuiNpcButton(16, this.guiLeft + 346, this.guiTop + 74, 35, 20, "type.up", !this.task.isEmpty() && pos != 0);
        button.setHoverText("quest.hover.edit.quest.up", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(17, this.guiLeft + 308, this.guiTop + 74, 35, 20, "type.down", !this.task.isEmpty() && pos > -1 && pos < this.tasksData.size() - 1);
        button.setHoverText("quest.hover.edit.quest.down", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(18, this.guiLeft + 172, this.guiTop + 192, 51, 20, new String[]{"attribute.slot.0", "quest.task.step.1", "quest.task.step.2"}, this.quest.step);
        button.setEnabled(!this.tasksData.isEmpty());
        button.setHoverText("quest.hover.edit.quest.step", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(19, this.guiLeft + 225, this.guiTop + 192, 50, 20, "gui.add", this.tasksData.size() < 9);
        button.setHoverText("quest.hover.edit.quest.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(20, this.guiLeft + 278, this.guiTop + 192, 50, 20, "gui.remove", this.scrollTasks.getSelected() != null);
        button.setHoverText("quest.hover.edit.quest.del", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(21, this.guiLeft + 331, this.guiTop + 192, 50, 20, "selectServer.edit", !this.task.isEmpty());
        button.setHoverText("quest.hover.edit.quest.edit", new Object[0]);
        this.addButton(button);
        button = new GuiButtonBiDirectional(8, this.guiLeft + 4, this.guiTop + 148, 166, 20, new String[]{"gui.no", "gui.yes", "quest.mcdaily", "quest.mcweekly", "quest.rldaily", "quest.rlweekly"}, this.quest.repeat.ordinal());
        button.setHoverText("quest.hover.edit.quest.repeat", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(9, this.guiLeft + 172, this.guiTop + 30, 90, 20, "gui.extraoptions");
        button.layerColor = new Color(-16711696).getRGB();
        button.setHoverText("quest.hover.edit.quest.extra", new Object[0]);
        this.addButton(button);
        if (this.quest.completer == null && this.npc != null) {
            this.quest.completer = this.npc;
            this.quest.completerPos[0] = (int)this.npc.field_70165_t;
            this.quest.completerPos[1] = (int)(this.npc.field_70163_u + 0.5);
            this.quest.completerPos[2] = (int)this.npc.field_70161_v;
            this.quest.completerPos[3] = this.npc.field_70170_p.field_73011_w.getDimension();
        }
        this.addLabel(new GuiNpcLabel(10, "faction.options", this.guiLeft + 4, this.guiTop + 101));
        button = new GuiNpcButton(10, this.guiLeft + 120, this.guiTop + 96, 50, 20, this.quest.factionOptions.hasOptions() ? "advanced.editingmode" : "selectServer.edit");
        button.setHoverText("quest.hover.edit.quest.faction", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(11, this.guiLeft + 4, this.guiTop + 192, 144, 20, "quest.next");
        if (this.quest.nextQuest != -1) {
            if (!this.quest.nextQuestTitle.isEmpty()) {
                button.setDisplayText(this.quest.nextQuestTitle);
            }
            Quest q = QuestController.instance.quests.get(this.quest.nextQuest);
            String hover = "";
            if (q != null) {
                hover = "<br>\u00a77" + new TextComponentTranslation(q.category.title, new Object[0]).func_150254_d() + '\u00a7' + "7/" + '\u00a7' + "r" + new TextComponentTranslation(q.title, new Object[0]).func_150254_d();
            }
            button.setHoverText(new TextComponentTranslation("quest.hover.edit.quest.next", new Object[0]).func_150254_d() + hover, new Object[0]);
        } else {
            button.setHoverText("quest.hover.edit.quest.next", new Object[0]);
        }
        this.addButton(button);
        button = new GuiNpcButton(12, this.guiLeft + 150, this.guiTop + 192, 20, 20, "X");
        button.setHoverText("quest.hover.edit.quest.del.next", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(13, this.guiLeft + 4, this.guiTop + 170, 144, 20, "mailbox.setup");
        if (!this.quest.mail.title.isEmpty()) {
            button.setDisplayText(this.quest.mail.title);
        }
        button.setHoverText("quest.hover.edit.quest.mail", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(14, this.guiLeft + 150, this.guiTop + 170, 20, 20, "X");
        button.setHoverText("quest.hover.edit.quest.del.mail", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(15, "advMode.command", this.guiLeft + 4, this.guiTop + 123));
        button = new GuiNpcButton(15, this.guiLeft + 120, this.guiTop + 118, 50, 20, this.quest.command.isEmpty() ? "selectServer.edit" : "advanced.editingmode");
        button.setHoverText("quest.hover.edit.quest.command", new Object[0]);
        this.addButton(button);
        GuiNpcLabel label = new GuiNpcLabel(16, "quest.has." + (this.quest.forgetDialogues.length > 0 || this.quest.forgetQuests.length > 0), this.guiLeft + 266, this.guiTop + 58);
        label.enabled = this.quest.isCancelable();
        this.addLabel(label);
        button = new GuiNpcButton(22, this.guiLeft + 172, this.guiTop + 52, 90, 20, new String[]{"quest.cancelable.true", "quest.cancelable.false"}, this.quest.isCancelable() ? 0 : 1);
        button.setHoverText("quest.hover.edit.quest.cancelable", new Object[0]);
        this.addButton(button);
        String[] lvls = new String[CustomNpcs.MaxLv + 1];
        lvls[0] = "gui.none";
        for (int g = 1; g <= CustomNpcs.MaxLv; ++g) {
            lvls[g] = "" + g;
        }
        button = new GuiButtonBiDirectional(23, this.guiLeft + 269, this.guiTop + 5, 50, 20, lvls, this.quest.level);
        button.setHoverText("quest.hover.edit.quest.level", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(24, this.guiLeft + 217, this.guiTop + 5, 50, 20, "gui.reset");
        button.setHoverText("hover.reset.id", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(66, this.guiLeft + 361, this.guiTop + 5, 20, 20, "X");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
    }

    private GuiNpcLabel getTasksLabel() {
        String[] isGet = new String[]{"2", "", ""};
        TreeMap<Integer, Dialog> dialogs = DialogController.instance.dialogs;
        for (int id : dialogs.keySet()) {
            if (dialogs.get((Object)Integer.valueOf((int)id)).quest != this.quest.id) continue;
            isGet = new String[]{"0", "" + id, "\u00a78" + dialogs.get((Object)Integer.valueOf((int)id)).category.title + "/" + '\u00a7' + "r" + dialogs.get((Object)Integer.valueOf((int)id)).title};
            break;
        }
        if (isGet[0].equals("2")) {
            TreeMap<Integer, Quest> quests = QuestController.instance.quests;
            for (int id : quests.keySet()) {
                if (id == this.quest.id || quests.get((Object)Integer.valueOf((int)id)).nextQuest != this.quest.id) continue;
                isGet = new String[]{"1", "" + id, "\u00a78" + quests.get((Object)Integer.valueOf((int)id)).category.title + "/" + '\u00a7' + "r" + quests.get(id).getTitle()};
                break;
            }
        }
        GuiNpcLabel label = new GuiNpcLabel(6, new TextComponentTranslation("gui.tasks", new Object[]{'\u00a7' + (isGet[0].equals("2") ? "4" : "2") + '\u00a7' + "l[?]"}).func_150254_d(), this.guiLeft + 174, this.guiTop + 84);
        label.setHoverText("quest.hover.edit.quest.tasks", new TextComponentTranslation("quest.hover.edit.is.get." + isGet[0], new Object[]{isGet[1], isGet[2]}).func_150254_d());
        return label;
    }

    @Override
    public void save() {
        GuiNpcTextField.unfocus();
        Client.sendData(EnumPacketServer.QuestSave, this.quest.category.id, this.quest.save(new NBTTagCompound()));
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (scroll.getSelected() == null) {
            return;
        }
        if (scroll.getID() == 6) {
            this.task = scroll.getSelected();
        }
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
        if (scroll.getID() == 6) {
            if (this.task.isEmpty()) {
                return;
            }
            if (this.tasksData.get(this.task).getEnumType() == EnumQuestTask.DIALOG) {
                this.setSubGui(new GuiNpcQuestTypeDialog(this.npc, this.tasksData.get(this.task), this));
            } else if (this.tasksData.get(this.task).getEnumType() == EnumQuestTask.KILL) {
                this.setSubGui(new GuiNpcQuestTypeKill(this.npc, this.tasksData.get(this.task), this));
            } else if (this.tasksData.get(this.task).getEnumType() == EnumQuestTask.LOCATION) {
                this.setSubGui(new GuiNpcQuestTypeLocation(this.npc, this.tasksData.get(this.task), this));
            } else if (this.tasksData.get(this.task).getEnumType() == EnumQuestTask.AREAKILL) {
                this.setSubGui(new GuiNpcQuestTypeKill(this.npc, this.tasksData.get(this.task), this));
            } else if (this.tasksData.get(this.task).getEnumType() == EnumQuestTask.MANUAL) {
                this.setSubGui(new GuiNpcQuestTypeManual(this.npc, this.tasksData.get(this.task), this));
            } else {
                Client.sendData(EnumPacketServer.QuestReset, this.quest.save(new NBTTagCompound()), this.quest.questInterface.getPos(this.tasksData.get(this.task)));
            }
        }
    }

    @Override
    public void selected(int id, String name) {
        this.quest.nextQuest = id;
        this.quest.nextQuestTitle = name;
        this.func_73866_w_();
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (compound != null && compound.func_150297_b("MinimumID", 3) && this.quest.id != compound.func_74762_e("MinimumID")) {
            Client.sendData(EnumPacketServer.QuestRemove, this.quest.id);
            this.quest.id = compound.func_74762_e("MinimumID");
            Client.sendData(EnumPacketServer.QuestSave, this.quest.category.id, this.quest.save(new NBTTagCompound()));
            this.func_73866_w_();
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        block15: {
            block13: {
                SubGuiNpcTextArea gui;
                block14: {
                    if (!(subgui instanceof SubGuiNpcTextArea)) break block13;
                    gui = (SubGuiNpcTextArea)subgui;
                    if (gui.getId() != 0) break block14;
                    this.quest.completeText = gui.text;
                    break block15;
                }
                if (gui.getId() != 1) break block15;
                this.quest.logText = gui.text;
                break block15;
            }
            if (subgui instanceof SubGuiNpcCommand) {
                SubGuiNpcCommand sub = (SubGuiNpcCommand)subgui;
                this.quest.command = sub.command;
            } else if (subgui instanceof SubGuiEditText && ((SubGuiEditText)subgui).text.length == 2) {
                while (((SubGuiEditText)subgui).text[0].contains(" ")) {
                    ((SubGuiEditText)subgui).text[0] = ((SubGuiEditText)subgui).text[0].replace(" ", "");
                }
                while (((SubGuiEditText)subgui).text[1].contains(" ")) {
                    ((SubGuiEditText)subgui).text[1] = ((SubGuiEditText)subgui).text[1].replace(" ", "");
                }
                ArrayList<Integer> vdt = new ArrayList<Integer>();
                for (String td : ((SubGuiEditText)subgui).text[0].split(",")) {
                    try {
                        int id = Integer.parseInt(td);
                        if (vdt.contains(id)) continue;
                        vdt.add(id);
                    }
                    catch (NumberFormatException e) {
                        LogWriter.error(e);
                    }
                }
                Collections.sort(vdt);
                this.quest.forgetDialogues = new int[vdt.size()];
                int i = 0;
                Iterator iterator = vdt.iterator();
                while (iterator.hasNext()) {
                    int id;
                    this.quest.forgetDialogues[i] = id = ((Integer)iterator.next()).intValue();
                    ++i;
                }
                ArrayList<Integer> vqt = new ArrayList<Integer>();
                for (String tq : ((SubGuiEditText)subgui).text[1].split(",")) {
                    try {
                        int id = Integer.parseInt(tq);
                        if (vqt.contains(id)) continue;
                        vqt.add(id);
                    }
                    catch (NumberFormatException e) {
                        LogWriter.error(e);
                    }
                }
                Collections.sort(vqt);
                this.quest.forgetQuests = new int[vqt.size()];
                i = 0;
                Iterator iterator2 = vqt.iterator();
                while (iterator2.hasNext()) {
                    int id;
                    this.quest.forgetQuests[i] = id = ((Integer)iterator2.next()).intValue();
                    ++i;
                }
            }
        }
        this.func_73866_w_();
    }

    @Override
    public void unFocused(IGuiNpcTextField guiNpcTextField) {
        if (guiNpcTextField.getID() == 1) {
            this.quest.setName(guiNpcTextField.getFullText());
            while (QuestController.instance.containsQuestName(this.quest.category, this.quest)) {
                StringBuilder sb = new StringBuilder();
                Quest quest = this.quest;
                quest.setName(sb.append(quest.getName()).append("_").toString());
            }
        }
        this.func_73866_w_();
    }
}

